//  Created by Allen Ingling on Fri Jun 18 2004.
//  Copyright (c) 2004 New York University. All rights reserved.

	
#import			"KeyRecorderWindow.h"
#include		"PrecisionTime.h"

@implementation KeyRecorderWindow

- (void)clearQueue
{
	[queue removeAllObjects];
}

- (void)stopQueue
{
	enableFlag=FALSE;
}

- (NSMutableArray*)getQueue
{
	NSMutableArray		*returnQueue;
	int					queueLength;
	int					foo;

	foo=numKeyPresses;
	queueLength=[queue count];
	returnQueue= [queue copy];
	[returnQueue autorelease];
	return(returnQueue);


}

- (void)startQueue
{
	//record the start time reference here
	timeReferenceMark=GetPrecisionTimeSinceStartupInSecsAsDouble();
	enableFlag=TRUE;

}

- (void)setEventTimeReference
{
	timeReferenceMark=GetPrecisionTimeSinceStartupInSecsAsDouble();
}

- (void)useAbsoluteEventTime
{
	timeReferenceMark=0;
}




//override methods

- init
{
    if (self = [super init]) {
		enableFlag=FALSE;
	}
    return(self);
}


- (void)awakeFromNib
{
	queue=[[NSMutableArray alloc] initWithCapacity:(unsigned)0];
	numKeyPresses=0;
}

- (void)dealloc
{
	[queue release];
	[super dealloc];
}

- (void)keyDown:(NSEvent *)theEvent
{
	CharTime		*charTime;
	unsigned		queueLength;
		
	++numKeyPresses;
	//add something here to subtract the start time recorded in startQueue from the time stamp
	if(enableFlag){
		charTime=[[CharTime alloc] init];
		[charTime setKeyString:[theEvent characters] timeStamp:[theEvent timestamp]-timeReferenceMark];
		queueLength=[queue count];
		[queue addObject:charTime];
		queueLength=[queue count];
		[charTime release]; 
	}  
}

- (int)getQueueLength
{
	return((int)[queue count]);
}



@end
